# TOP LEVEL CONFIGURATION
set_property CONFIG_VOLTAGE 3.3 [current_design]
set_property CFGBVS VCCO [current_design]

create_clock -name ema_clk -period 10 [get_ports i_ema_clk]

# ported UCF offset delay in/out constraints
# OFFSET = IN 3 ns VALID 4 ns BEFORE "i_ema_clk" RISING;
set_input_delay -clock ema_clk -min 3 [all_inputs]
set_input_delay -clock ema_clk -max 9 [all_inputs]

# OMAP-l138 EMIF requires 8 ns of setup time (it's awful)
set_output_delay -clock ema_clk 8 [get_ports {io_ema_d[*]}]
# our emifa interface design asserts data for 2 clock periods (leads by 1 clock)
# the emi_clk_1 is the output clock from the MMCM BUFG output.
set_multicycle_path -setup 2 -from [get_clocks ema_clk_1] -to [get_ports {io_ema_d[*]}]
set_multicycle_path -hold 1 -from [get_clocks ema_clk_1] -to [get_ports {io_ema_d[*]}]

# for now ignore paths for chips select and OE to io_emd_d[*] outputs, these are actually multi-cycle 
# and should be stable long before the clock cycle from the data assertions
set_false_path -from {i_ema_cs5_n} -to {io_ema_d[*]}
set_false_path -from {i_ema_cs4_n} -to {io_ema_d[*]}
set_false_path -from {i_ema_oe_n} -to {io_ema_d[*]}

# IO Standard Constraints, EMIFA and IRQ Interface
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_clk}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_cs0_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_cs2_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_cs3_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_cs4_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_cs5_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_oe_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_we_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_cas}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_ras}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_sdcke}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_rnw}]
set_property IOSTANDARD LVCMOS33 [get_ports {o_nmi_n}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[0]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[5]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[6]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[8]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[9]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[10]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[11]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[12]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[13]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[14]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_d[15]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[0]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[5]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[6]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[8]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[9]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[10]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[11]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[12]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_a[13]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_ba[0]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_ba[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_wait_n[0]}]
set_property IOSTANDARD LVCMOS33 [get_ports {io_ema_wait_n[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_wen_dqm[0]}]
set_property IOSTANDARD LVCMOS33 [get_ports {i_ema_wen_dqm[1]}]

set_property IOSTANDARD LVCMOS18 [get_ports {o_int[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {o_int[1]}]

set_property PACKAGE_PIN T9 [get_ports {i_ema_cs0_n}]
set_property PACKAGE_PIN U12 [get_ports {i_ema_cs2_n}]
set_property PACKAGE_PIN U13 [get_ports {i_ema_cs3_n}]
set_property PACKAGE_PIN T16 [get_ports {i_ema_cs4_n}]
set_property PACKAGE_PIN U14 [get_ports {i_ema_oe_n}]
set_property PACKAGE_PIN L13 [get_ports {i_ema_cas}]
set_property PACKAGE_PIN V14 [get_ports {i_ema_ras}]
set_property PACKAGE_PIN N17 [get_ports {i_ema_sdcke}]
set_property PACKAGE_PIN R11 [get_ports {o_nmi_n}]
set_property PACKAGE_PIN V15 [get_ports {i_ema_cs5_n}]
set_property PACKAGE_PIN R16 [get_ports {i_ema_rnw}]
set_property PACKAGE_PIN L16 [get_ports {i_ema_we_n}]
set_property PACKAGE_PIN P15 [get_ports {i_ema_clk}]
set_property PACKAGE_PIN K17 [get_ports {io_ema_d[0]}]
set_property PACKAGE_PIN K18 [get_ports {io_ema_d[1]}]
set_property PACKAGE_PIN L14 [get_ports {io_ema_d[2]}]
set_property PACKAGE_PIN M14 [get_ports {io_ema_d[3]}]
set_property PACKAGE_PIN L18 [get_ports {io_ema_d[4]}]
set_property PACKAGE_PIN M18 [get_ports {io_ema_d[5]}]
set_property PACKAGE_PIN R12 [get_ports {io_ema_d[6]}]
set_property PACKAGE_PIN R13 [get_ports {io_ema_d[7]}]
set_property PACKAGE_PIN M13 [get_ports {io_ema_d[8]}]
set_property PACKAGE_PIN R18 [get_ports {io_ema_d[9]}]
set_property PACKAGE_PIN T18 [get_ports {io_ema_d[10]}]
set_property PACKAGE_PIN N14 [get_ports {io_ema_d[11]}]
set_property PACKAGE_PIN P14 [get_ports {io_ema_d[12]}]
set_property PACKAGE_PIN P18 [get_ports {io_ema_d[13]}]
set_property PACKAGE_PIN M16 [get_ports {io_ema_d[14]}]
set_property PACKAGE_PIN M17 [get_ports {io_ema_d[15]}]
set_property PACKAGE_PIN V12 [get_ports {i_ema_a[0]}]
set_property PACKAGE_PIN U11 [get_ports {i_ema_a[1]}]
set_property PACKAGE_PIN U18 [get_ports {i_ema_a[2]}]
set_property PACKAGE_PIN V11 [get_ports {i_ema_a[3]}]
set_property PACKAGE_PIN U17 [get_ports {i_ema_a[4]}]
set_property PACKAGE_PIN V16 [get_ports {i_ema_a[5]}]
set_property PACKAGE_PIN T14 [get_ports {i_ema_a[6]}]
set_property PACKAGE_PIN N16 [get_ports {i_ema_a[7]}]
set_property PACKAGE_PIN N15 [get_ports {i_ema_a[8]}]
set_property PACKAGE_PIN V10 [get_ports {i_ema_a[9]}]
set_property PACKAGE_PIN U16 [get_ports {i_ema_a[10]}]
set_property PACKAGE_PIN R15 [get_ports {i_ema_a[11]}]
set_property PACKAGE_PIN P17 [get_ports {i_ema_a[12]}]
set_property PACKAGE_PIN V17 [get_ports {i_ema_a[13]}]
set_property PACKAGE_PIN T13 [get_ports {i_ema_ba[0]}]
set_property PACKAGE_PIN T11 [get_ports {i_ema_ba[1]}]
set_property PACKAGE_PIN T10 [get_ports {io_ema_wait_n[0]}]
set_property PACKAGE_PIN R10 [get_ports {io_ema_wait_n[1]}]
set_property PACKAGE_PIN R17 [get_ports {i_ema_wen_dqm[0]}]
set_property PACKAGE_PIN T15 [get_ports {i_ema_wen_dqm[1]}]
set_property PACKAGE_PIN A10 [get_ports {o_int[0]}]
set_property PACKAGE_PIN A9 [get_ports {o_int[1]}]

#### Below are the DDR edge connector interfaces, you will need to set the IOSTANDARD accordingly
#set_property PACKAGE_PIN J17	[get_ports {PIN_91_B15_47_P}]	
#set_property PACKAGE_PIN K13	[get_ports {PIN_92_B15_48_P}]
#set_property PACKAGE_PIN J18	[get_ports {PIN_93_B15_47_N}]	
#set_property PACKAGE_PIN J13	[get_ports {PIN_94_B15_48_N}]
#set_property PACKAGE_PIN H17	[get_ports {PIN_95_B15_45_P}]	
#set_property PACKAGE_PIN H14	[get_ports {PIN_96_B15_46_P}]
#set_property PACKAGE_PIN G17	[get_ports {PIN_97_B15_45_N}]	
#set_property PACKAGE_PIN G14	[get_ports {PIN_98_B15_46_N}]
#set_property PACKAGE_PIN G18	[get_ports {PIN_99_B15_43_P}]	
#set_property PACKAGE_PIN H16	[get_ports {PIN_100_B15_44_P}]
#set_property PACKAGE_PIN F18	[get_ports {PIN_101_B15_43_N}]	
#set_property PACKAGE_PIN G16	[get_ports {PIN_102_B15_44_N}]
#set_property PACKAGE_PIN K15	[get_ports {PIN_103_B15_41_P}]	
#set_property PACKAGE_PIN F13	[get_ports {PIN_104_B15_42_P}]
#set_property PACKAGE_PIN J15	[get_ports {PIN_105_B15_41_N}]	
#set_property PACKAGE_PIN F14	[get_ports {PIN_106_B15_42_N}]
#set_property PACKAGE_PIN J14	[get_ports {PIN_109_B15_39_P}]	
#set_property PACKAGE_PIN F15	[get_ports {PIN_110_B15_40_P}]
#set_property PACKAGE_PIN H15	[get_ports {PIN_111_B15_39_N}]	
#set_property PACKAGE_PIN F16	[get_ports {PIN_112_B15_40_N}]
#set_property PACKAGE_PIN E18	[get_ports {PIN_113_B15_37_P}]	
#set_property PACKAGE_PIN E15	[get_ports {PIN_114_B15_38_P}]
#set_property PACKAGE_PIN D18	[get_ports {PIN_115_B15_37_N}]	
#set_property PACKAGE_PIN E16	[get_ports {PIN_116_B15_38_N}]
#set_property PACKAGE_PIN E17	[get_ports {PIN_117_B15_35_P}]	
#set_property PACKAGE_PIN C16	[get_ports {PIN_118_B15_36_P}]
#set_property PACKAGE_PIN D17	[get_ports {PIN_119_B15_35_N}]	
#set_property PACKAGE_PIN C17	[get_ports {PIN_120_B15_36_N}]
#set_property PACKAGE_PIN B18	[get_ports {PIN_121_B15_33_P}]	
#set_property PACKAGE_PIN B16	[get_ports {PIN_122_B15_34_P}]
#set_property PACKAGE_PIN A18	[get_ports {PIN_123_B15_33_N}]	
#set_property PACKAGE_PIN B17	[get_ports {PIN_124_B15_34_N}]
#set_property PACKAGE_PIN D15	[get_ports {PIN_125_B15_31_P}]	
#set_property PACKAGE_PIN D14	[get_ports {PIN_126_B15_32_P}]
#set_property PACKAGE_PIN C15	[get_ports {PIN_127_B15_31_N}]	
#set_property PACKAGE_PIN C14	[get_ports {PIN_128_B15_32_N}]
#set_property PACKAGE_PIN A15	[get_ports {PIN_131_B15_29_P}]	
#set_property PACKAGE_PIN B13	[get_ports {PIN_132_B15_30_P}]
#set_property PACKAGE_PIN A16	[get_ports {PIN_133_B15_29_N}]	
#set_property PACKAGE_PIN B14	[get_ports {PIN_134_B15_30_N}]
#set_property PACKAGE_PIN A13	[get_ports {PIN_135_B15_27_P}]	
#set_property PACKAGE_PIN C12	[get_ports {PIN_136_B15_28_P}]
#set_property PACKAGE_PIN A14	[get_ports {PIN_137_B15_27_N}]	
#set_property PACKAGE_PIN B12	[get_ports {PIN_138_B15_28_N}]
#set_property PACKAGE_PIN B11	[get_ports {PIN_139_B15_25_P}]	
#set_property PACKAGE_PIN D12	[get_ports {PIN_140_B15_26_P}]
#set_property PACKAGE_PIN A11	[get_ports {PIN_141_B15_25_N}]	
#set_property PACKAGE_PIN D13	[get_ports {PIN_142_B15_26_N}]
#set_property PACKAGE_PIN E6	[get_ports {PIN_143_B35_23_P}]	
#set_property PACKAGE_PIN H6	[get_ports {PIN_144_B35_24_P}]
#set_property PACKAGE_PIN E5	[get_ports {PIN_145_B35_23_N}]	
#set_property PACKAGE_PIN H5	[get_ports {PIN_146_B35_24_N}]
#set_property PACKAGE_PIN C6	[get_ports {PIN_147_B35_21_P}]	
#set_property PACKAGE_PIN E7	[get_ports {PIN_148_B35_22_P}]
#set_property PACKAGE_PIN C5	[get_ports {PIN_149_B35_21_N}]	
#set_property PACKAGE_PIN D7	[get_ports {PIN_150_B35_22_N}]
#set_property PACKAGE_PIN B7	[get_ports {PIN_153_B35_19_P}]	
#set_property PACKAGE_PIN D8	[get_ports {PIN_154_B35_20_P}]
#set_property PACKAGE_PIN B6	[get_ports {PIN_155_B35_19_N}]	
#set_property PACKAGE_PIN C7	[get_ports {PIN_156_B35_20_N}]
#set_property PACKAGE_PIN A6	[get_ports {PIN_157_B35_17_P}]	
#set_property PACKAGE_PIN G6	[get_ports {PIN_158_B35_18_P}]
#set_property PACKAGE_PIN A5	[get_ports {PIN_159_B35_17_N}]	
#set_property PACKAGE_PIN F6	[get_ports {PIN_160_B35_18_N}]
#set_property PACKAGE_PIN A4	[get_ports {PIN_161_B35_15_P}]	
#set_property PACKAGE_PIN G4	[get_ports {PIN_162_B35_16_P}]
#set_property PACKAGE_PIN A3	[get_ports {PIN_163_B35_15_N}]	
#set_property PACKAGE_PIN G3	[get_ports {PIN_164_B35_16_N}]
#set_property PACKAGE_PIN B1	[get_ports {PIN_165_B35_13_P}]	
#set_property PACKAGE_PIN D5	[get_ports {PIN_166_B35_14_P}]
#set_property PACKAGE_PIN A1	[get_ports {PIN_167_B35_13_N}]	
#set_property PACKAGE_PIN D4	[get_ports {PIN_168_B35_14_N}]
#set_property PACKAGE_PIN C2	[get_ports {PIN_169_B35_11_P}]	
#set_property PACKAGE_PIN C4	[get_ports {PIN_170_B35_12_P}]
#set_property PACKAGE_PIN C1	[get_ports {PIN_171_B35_11_N}]	
#set_property PACKAGE_PIN B4	[get_ports {PIN_172_B35_12_N}]
#set_property PACKAGE_PIN F1	[get_ports {PIN_175_B35_9_P}]	
#set_property PACKAGE_PIN E3	[get_ports {PIN_176_B35_10_P}]
#set_property PACKAGE_PIN E1	[get_ports {PIN_177_B35_9_N}]	
#set_property PACKAGE_PIN D3	[get_ports {PIN_178_B35_10_N}]
#set_property PACKAGE_PIN E2	[get_ports {PIN_179_B35_7_P}]	
#set_property PACKAGE_PIN B3	[get_ports {PIN_180_B35_8_P}]
#set_property PACKAGE_PIN D2	[get_ports {PIN_181_B35_7_N}]	
#set_property PACKAGE_PIN B2	[get_ports {PIN_182_B35_8_N}]
#set_property PACKAGE_PIN F4	[get_ports {PIN_183_B35_5_P}]	
#set_property PACKAGE_PIN H2	[get_ports {PIN_184_B35_6_P}]
#set_property PACKAGE_PIN F3	[get_ports {PIN_185_B35_5_N}]	
#set_property PACKAGE_PIN G2	[get_ports {PIN_186_B35_6_N}]
#set_property PACKAGE_PIN H1	[get_ports {PIN_187_B35_3_P}]	
#set_property PACKAGE_PIN J4	[get_ports {PIN_188_B35_4_P}]
#set_property PACKAGE_PIN G1	[get_ports {PIN_189_B35_3_N}]	
#set_property PACKAGE_PIN H4	[get_ports {PIN_190_B35_4_N}]
#set_property PACKAGE_PIN K2	[get_ports {PIN_191_B35_1_P}]	
#set_property PACKAGE_PIN J3	[get_ports {PIN_192_B35_2_P}]
#set_property PACKAGE_PIN K1	[get_ports {PIN_193_B35_1_N}]	
#set_property PACKAGE_PIN J2	[get_ports {PIN_194_B35_2_N}]

#### Below are OMAP-L138 to FPGA interfaces that may optionally be used depending on your application

### Ethernet Media Access Controller (EMAC) RMII
#create_clock -name rmii_clk -period 10 [get_ports io_rmii_mhz_50_clk]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_rmii_mhz_50_clk}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_rmii_rxer}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_rmii_rxd[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_rmii_rxd[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_rmii_crs_dv}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_rmii_txen}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_rmii_txd[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_rmii_txd[1]}]
#set_property PACKAGE_PIN R3 [get_ports {io_rmii_mhz_50_clk}]
#set_property PACKAGE_PIN P2 [get_ports {o_rmii_rxer}]
#set_property PACKAGE_PIN N1 [get_ports {o_rmii_rxd[0]}]
#set_property PACKAGE_PIN T1 [get_ports {o_rmii_rxd[1]}]
#set_property PACKAGE_PIN M1 [get_ports {o_rmii_crs_dv}]
#set_property PACKAGE_PIN L5 [get_ports {i_rmii_txen}]
#set_property PACKAGE_PIN R1 [get_ports {i_rmii_txd[0]}]
#set_property PACKAGE_PIN K5 [get_ports {i_rmii_txd[1]}]

#### Multimedia Card/Secure Digital (MMC/SD) MMCSD1
#set_property IOSTANDARD LVCMOS18 [get_ports {i_mmcsd1_clk}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_cmd}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_mmcsd1_dat[7]}]
#set_property PACKAGE_PIN T6 [get_ports {i_mmcsd1_clk}]
#set_property PACKAGE_PIN V7 [get_ports {io_mmcsd1_cmd}]
#set_property PACKAGE_PIN T4 [get_ports {io_mmcsd1_dat[0]}]
#set_property PACKAGE_PIN U6 [get_ports {io_mmcsd1_dat[1]}]
#set_property PACKAGE_PIN T8 [get_ports {io_mmcsd1_dat[2]}]
#set_property PACKAGE_PIN T5 [get_ports {io_mmcsd1_dat[3]}]
#set_property PACKAGE_PIN U9 [get_ports {io_mmcsd1_dat[4]}]
#set_property PACKAGE_PIN U8 [get_ports {io_mmcsd1_dat[5]}]
#set_property PACKAGE_PIN P4 [get_ports {io_mmcsd1_dat[6]}]
#set_property PACKAGE_PIN N2 [get_ports {io_mmcsd1_dat[7]}]

#### LCD / Video Output Port
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[7]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[14]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_lcd_d[15]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_lcd_hsync}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_lcd_vsync}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_lcd_mclk}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_lcd_pclk}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_lcd_ac_enb_cs}]
#set_property PACKAGE_PIN P3 [get_ports {io_lcd_d[0]}]
#set_property PACKAGE_PIN R8 [get_ports {io_lcd_d[1]}]
#set_property PACKAGE_PIN V4 [get_ports {io_lcd_d[2]}]
#set_property PACKAGE_PIN M4 [get_ports {io_lcd_d[3]}]
#set_property PACKAGE_PIN N4 [get_ports {io_lcd_d[4]}]
#set_property PACKAGE_PIN U7 [get_ports {io_lcd_d[5]}]
#set_property PACKAGE_PIN M6 [get_ports {io_lcd_d[6]}]
#set_property PACKAGE_PIN R7 [get_ports {io_lcd_d[7]}]
#set_property PACKAGE_PIN U2 [get_ports {io_lcd_d[8]}]
#set_property PACKAGE_PIN R6 [get_ports {io_lcd_d[9]}]
#set_property PACKAGE_PIN N6 [get_ports {io_lcd_d[10]}]
#set_property PACKAGE_PIN V2 [get_ports {io_lcd_d[11]}]
#set_property PACKAGE_PIN P5 [get_ports {io_lcd_d[12]}]
#set_property PACKAGE_PIN R5 [get_ports {io_lcd_d[13]}]
#set_property PACKAGE_PIN U3 [get_ports {io_lcd_d[14]}]
#set_property PACKAGE_PIN V5 [get_ports {io_lcd_d[15]}]
#set_property PACKAGE_PIN U8 [get_ports {i_lcd_hsync}]
#set_property PACKAGE_PIN U9 [get_ports {i_lcd_vsync}]
#set_property PACKAGE_PIN N2 [get_ports {i_lcd_mclk}]
#set_property PACKAGE_PIN P4 [get_ports {i_lcd_pclk}]
#set_property PACKAGE_PIN D9 [get_ports {i_lcd_ac_enb_cs}]

#### Universal Parallel Port (uPP)
#set_property IOSTANDARD LVCMOS18 [get_ports {o_upp_2xtxclk}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_chb_clock}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_chb_start}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_chb_enable}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_chb_wait}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_cha_clock}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_cha_start}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_cha_enable}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_cha_wait}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[15]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[14]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[7]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_xd[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[15]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[14]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[7]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_upp_d[0]}]

#set_property PACKAGE_PIN L3 [get_ports {o_upp_2xtxclk}]
## chb = ch0
#set_property PACKAGE_PIN T4 [get_ports {io_upp_chb_clock}]
#set_property PACKAGE_PIN T6 [get_ports {io_upp_chb_start}]
#set_property PACKAGE_PIN V7 [get_ports {io_upp_chb_enable}]
#set_property PACKAGE_PIN V9 [get_ports {io_upp_chb_wait}]
## cha = ch1
#set_property PACKAGE_PIN N5 [get_ports {io_upp_cha_clock}]
#set_property PACKAGE_PIN V1 [get_ports {io_upp_cha_start}]
#set_property PACKAGE_PIN U4 [get_ports {io_upp_cha_enable}]
#set_property PACKAGE_PIN L6 [get_ports {io_upp_cha_wait}]
#set_property PACKAGE_PIN U2 [get_ports {io_upp_xd[0]}]
#set_property PACKAGE_PIN R6 [get_ports {io_upp_xd[1]}]
#set_property PACKAGE_PIN N6 [get_ports {io_upp_xd[2]}]
#set_property PACKAGE_PIN V2 [get_ports {io_upp_xd[3]}]
#set_property PACKAGE_PIN P5 [get_ports {io_upp_xd[4]}]
#set_property PACKAGE_PIN R5 [get_ports {io_upp_xd[5]}]
#set_property PACKAGE_PIN U3 [get_ports {io_upp_xd[6]}]
#set_property PACKAGE_PIN V5 [get_ports {io_upp_xd[7]}]
#set_property PACKAGE_PIN P3 [get_ports {io_upp_xd[8]}]
#set_property PACKAGE_PIN R8 [get_ports {io_upp_xd[9]}]
#set_property PACKAGE_PIN V4 [get_ports {io_upp_xd[10]}]
#set_property PACKAGE_PIN M4 [get_ports {io_upp_xd[11]}]
#set_property PACKAGE_PIN N4 [get_ports {io_upp_xd[12]}]
#set_property PACKAGE_PIN U7 [get_ports {io_upp_xd[13]}]
#set_property PACKAGE_PIN M6 [get_ports {io_upp_xd[14]}]
#set_property PACKAGE_PIN R7 [get_ports {io_upp_xd[15]}]
#set_property PACKAGE_PIN M3 [get_ports {io_upp_d[0]}]
#set_property PACKAGE_PIN K6 [get_ports {io_upp_d[1]}]
#set_property PACKAGE_PIN T3 [get_ports {io_upp_d[2]}]
#set_property PACKAGE_PIN R2 [get_ports {io_upp_d[3]}]
#set_property PACKAGE_PIN K3 [get_ports {io_upp_d[4]}]
#set_property PACKAGE_PIN L4 [get_ports {io_upp_d[5]}]
#set_property PACKAGE_PIN L1 [get_ports {io_upp_d[6]}]
#set_property PACKAGE_PIN M2 [get_ports {io_upp_d[7]}]
#set_property PACKAGE_PIN M1 [get_ports {io_upp_d[8]}]
#set_property PACKAGE_PIN R3 [get_ports {io_upp_d[9]}]
#set_property PACKAGE_PIN P2 [get_ports {io_upp_d[10]}]
#set_property PACKAGE_PIN N1 [get_ports {io_upp_d[11]}]
#set_property PACKAGE_PIN T1 [get_ports {io_upp_d[12]}]
#set_property PACKAGE_PIN L5 [get_ports {io_upp_d[13]}]
#set_property PACKAGE_PIN R1 [get_ports {io_upp_d[14]}]
#set_property PACKAGE_PIN K5 [get_ports {io_upp_d[15]}]

#### Video Port Interface (VPIF)
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_clkin0}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_clkin1}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_vsync}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_hsync}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_field}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_clkin2}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_clkout2}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_clkout3}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[7]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[14]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {o_vp_din[15]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[7]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[14]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {i_vp_dout[15]}]
#set_property PACKAGE_PIN U1 [get_ports {o_vp_clkin0}]
#set_property PACKAGE_PIN L3 [get_ports {o_vp_clkin1}]
#set_property PACKAGE_PIN L1 [get_ports {o_vp_vsync}]
#set_property PACKAGE_PIN M2 [get_ports {o_vp_hsync}]
#set_property PACKAGE_PIN L4 [get_ports {o_vp_field}]
#set_property PACKAGE_PIN T8 [get_ports {o_vp_clkin2}]
#set_property PACKAGE_PIN T5 [get_ports {i_vp_clkout2}]
#set_property PACKAGE_PIN V6 [get_ports {i_vp_clkout3}]
#set_property PACKAGE_PIN M1 [get_ports {o_vp_din[0]}]
#set_property PACKAGE_PIN R3 [get_ports {o_vp_din[1]}]
#set_property PACKAGE_PIN P2 [get_ports {o_vp_din[2]}]
#set_property PACKAGE_PIN N1 [get_ports {o_vp_din[3]}]
#set_property PACKAGE_PIN T1 [get_ports {o_vp_din[4]}]
#set_property PACKAGE_PIN L5 [get_ports {o_vp_din[5]}]
#set_property PACKAGE_PIN R1 [get_ports {o_vp_din[6]}]
#set_property PACKAGE_PIN K5 [get_ports {o_vp_din[7]}]
#set_property PACKAGE_PIN M3 [get_ports {o_vp_din[8]}]
#set_property PACKAGE_PIN K6 [get_ports {o_vp_din[9]}]
#set_property PACKAGE_PIN T3 [get_ports {o_vp_din[10]}]
#set_property PACKAGE_PIN R2 [get_ports {o_vp_din[11]}]
#set_property PACKAGE_PIN K3 [get_ports {o_vp_din[12]}]
#set_property PACKAGE_PIN L4 [get_ports {o_vp_din[13]}]
#set_property PACKAGE_PIN L1 [get_ports {o_vp_din[14]}]
#set_property PACKAGE_PIN M2 [get_ports {o_vp_din[15]}]
#set_property PACKAGE_PIN P3 [get_ports {i_vp_dout[0]}]
#set_property PACKAGE_PIN R8 [get_ports {i_vp_dout[1]}]
#set_property PACKAGE_PIN V4 [get_ports {i_vp_dout[2]}]
#set_property PACKAGE_PIN M4 [get_ports {i_vp_dout[3]}]
#set_property PACKAGE_PIN N4 [get_ports {i_vp_dout[4]}]
#set_property PACKAGE_PIN U7 [get_ports {i_vp_dout[5]}]
#set_property PACKAGE_PIN M6 [get_ports {i_vp_dout[6]}]
#set_property PACKAGE_PIN R7 [get_ports {i_vp_dout[7]}]
#set_property PACKAGE_PIN U2 [get_ports {i_vp_dout[8]}]
#set_property PACKAGE_PIN R6 [get_ports {i_vp_dout[9]}]
#set_property PACKAGE_PIN N6 [get_ports {i_vp_dout[10]}]
#set_property PACKAGE_PIN V2 [get_ports {i_vp_dout[11]}]
#set_property PACKAGE_PIN P5 [get_ports {i_vp_dout[12]}]
#set_property PACKAGE_PIN R5 [get_ports {i_vp_dout[13]}]
#set_property PACKAGE_PIN U3 [get_ports {i_vp_dout[14]}]
#set_property PACKAGE_PIN V5 [get_ports {i_vp_dout[15]}]

#### General Purpose Input Output (GPIO)
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[0]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[1]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[2]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[3]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[4]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[5]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[6]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[7]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[8]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp2[9]}]
#set_property PACKAGE_PIN T9 [get_ports {io_gp2[0]}]
#set_property PACKAGE_PIN R10 [get_ports {io_gp2[1]}]
#set_property PACKAGE_PIN T15 [get_ports {io_gp2[2]}]
#set_property PACKAGE_PIN R17 [get_ports {io_gp2[3]}]
#set_property PACKAGE_PIN L13 [get_ports {io_gp2[4]}]
#set_property PACKAGE_PIN V14 [get_ports {io_gp2[5]}]
#set_property PACKAGE_PIN N17 [get_ports {io_gp2[6]}]
#set_property PACKAGE_PIN P15 [get_ports {io_gp2[7]}]
#set_property PACKAGE_PIN T13 [get_ports {io_gp2[8]}]
#set_property PACKAGE_PIN T11 [get_ports {io_gp2[9]}]

#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[0]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[1]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[2]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[3]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[4]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[5]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[6]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[7]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[8]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[9]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[10]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[11]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[12]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[13]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[14]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp3[15]}]
#set_property PACKAGE_PIN M13 [get_ports {io_gp3[0]}]
#set_property PACKAGE_PIN R18 [get_ports {io_gp3[1]}]
#set_property PACKAGE_PIN T18 [get_ports {io_gp3[2]}]
#set_property PACKAGE_PIN N14 [get_ports {io_gp3[3]}]
#set_property PACKAGE_PIN P14 [get_ports {io_gp3[4]}]
#set_property PACKAGE_PIN P18 [get_ports {io_gp3[5]}]
#set_property PACKAGE_PIN M16 [get_ports {io_gp3[6]}]
#set_property PACKAGE_PIN M17 [get_ports {io_gp3[7]}]
#set_property PACKAGE_PIN T10 [get_ports {io_gp3[8]}]
#set_property PACKAGE_PIN R16 [get_ports {io_gp3[9]}]
#set_property PACKAGE_PIN U14 [get_ports {io_gp3[10]}]
#set_property PACKAGE_PIN L16 [get_ports {io_gp3[11]}]
#set_property PACKAGE_PIN V15 [get_ports {io_gp3[12]}]
#set_property PACKAGE_PIN T16 [get_ports {io_gp3[13]}]
#set_property PACKAGE_PIN U13 [get_ports {io_gp3[14]}]
#set_property PACKAGE_PIN U12 [get_ports {io_gp3[15]}]

#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[8]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[9]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[10]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[11]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[12]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[13]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[14]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp4[15]}]
#set_property PACKAGE_PIN K17 [get_ports {io_gp4[8]}]
#set_property PACKAGE_PIN K18 [get_ports {io_gp4[9]}]
#set_property PACKAGE_PIN L14 [get_ports {io_gp4[10]}]
#set_property PACKAGE_PIN M14 [get_ports {io_gp4[11]}]
#set_property PACKAGE_PIN L18 [get_ports {io_gp4[12]}]
#set_property PACKAGE_PIN M18 [get_ports {io_gp4[13]}]
#set_property PACKAGE_PIN R12 [get_ports {io_gp4[14]}]
#set_property PACKAGE_PIN R13 [get_ports {io_gp4[15]}]

#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[0]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[1]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[2]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[3]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[4]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[5]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[6]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[7]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[8]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[9]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[10]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[11]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[12]}]
#set_property IOSTANDARD LVCMOS33 [get_ports {io_gp5[13]}]
#set_property PACKAGE_PIN V12 [get_ports {io_gp5[0]}]
#set_property PACKAGE_PIN U11 [get_ports {io_gp5[1]}]
#set_property PACKAGE_PIN U18 [get_ports {io_gp5[2]}]
#set_property PACKAGE_PIN V11 [get_ports {io_gp5[3]}]
#set_property PACKAGE_PIN U17 [get_ports {io_gp5[4]}]
#set_property PACKAGE_PIN V16 [get_ports {io_gp5[5]}]
#set_property PACKAGE_PIN T14 [get_ports {io_gp5[6]}]
#set_property PACKAGE_PIN N16 [get_ports {io_gp5[7]}]
#set_property PACKAGE_PIN N15 [get_ports {io_gp5[8]}]
#set_property PACKAGE_PIN V10 [get_ports {io_gp5[9]}]
#set_property PACKAGE_PIN U16 [get_ports {io_gp5[10]}]
#set_property PACKAGE_PIN R15 [get_ports {io_gp5[11]}]
#set_property PACKAGE_PIN P17 [get_ports {io_gp5[12]}]
#set_property PACKAGE_PIN V17 [get_ports {io_gp5[13]}]

#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[7]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp6[14]}]
#set_property PACKAGE_PIN D9 [get_ports {io_gp6[0]}]
#set_property PACKAGE_PIN V6 [get_ports {io_gp6[1]}]
#set_property PACKAGE_PIN U6 [get_ports {io_gp6[2]}]
#set_property PACKAGE_PIN T5 [get_ports {io_gp6[3]}]
#set_property PACKAGE_PIN T8 [get_ports {io_gp6[4]}]
#set_property PACKAGE_PIN M3 [get_ports {io_gp6[5]}]
#set_property PACKAGE_PIN U1 [get_ports {io_gp6[6]}]
#set_property PACKAGE_PIN L3 [get_ports {io_gp6[7]}]
#set_property PACKAGE_PIN L6 [get_ports {io_gp6[8]}]
#set_property PACKAGE_PIN U4 [get_ports {io_gp6[9]}]
#set_property PACKAGE_PIN V1 [get_ports {io_gp6[10]}]
#set_property PACKAGE_PIN N5 [get_ports {io_gp6[11]}]
#set_property PACKAGE_PIN A10 [get_ports {io_gp6[12]}]
#set_property PACKAGE_PIN A9 [get_ports {io_gp6[13]}]
#set_property PACKAGE_PIN C11 [get_ports {io_gp6[14]}]

#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[2]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[3]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[4]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[5]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[6]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[7]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[14]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp7[15]}]
#set_property PACKAGE_PIN U2 [get_ports {io_gp7[0]}]
#set_property PACKAGE_PIN R6 [get_ports {io_gp7[1]}]
#set_property PACKAGE_PIN N6 [get_ports {io_gp7[2]}]
#set_property PACKAGE_PIN V2 [get_ports {io_gp7[3]}]
#set_property PACKAGE_PIN P5 [get_ports {io_gp7[4]}]
#set_property PACKAGE_PIN R5 [get_ports {io_gp7[5]}]
#set_property PACKAGE_PIN U3 [get_ports {io_gp7[6]}]
#set_property PACKAGE_PIN V5 [get_ports {io_gp7[7]}]
#set_property PACKAGE_PIN P3 [get_ports {io_gp7[8]}]
#set_property PACKAGE_PIN R8 [get_ports {io_gp7[9]}]
#set_property PACKAGE_PIN V4 [get_ports {io_gp7[10]}]
#set_property PACKAGE_PIN M4 [get_ports {io_gp7[11]}]
#set_property PACKAGE_PIN N4 [get_ports {io_gp7[12]}]
#set_property PACKAGE_PIN U7 [get_ports {io_gp7[13]}]
#set_property PACKAGE_PIN M6 [get_ports {io_gp7[14]}]
#set_property PACKAGE_PIN R7 [get_ports {io_gp7[15]}]

#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[8]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[9]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[10]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[11]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[12]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[13]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[14]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {io_gp8[15]}]
#set_property PACKAGE_PIN U9 [get_ports {io_gp8[8]}]
#set_property PACKAGE_PIN U8 [get_ports {io_gp8[9]}]
#set_property PACKAGE_PIN N2 [get_ports {io_gp8[10]}]
#set_property PACKAGE_PIN P4 [get_ports {io_gp8[11]}]
#set_property PACKAGE_PIN V9 [get_ports {io_gp8[12]}]
#set_property PACKAGE_PIN V7 [get_ports {io_gp8[13]}]
#set_property PACKAGE_PIN T6 [get_ports {io_gp8[14]}]
#set_property PACKAGE_PIN T4 [get_ports {io_gp8[15]}]