#include <linux/serial.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <termios.h>

/* Driver-specific ioctls: */
#define TIOCGRS485 0x542E
#define TIOCSRS485 0x542F

/* new defines in linux/serial.h of CL provided kernel */
#ifndef SER_RS485_USE_GPIO
#define SER_RS485_USE_GPIO (1<<5)
#define gpio_pin padding[0]
#endif

/* Convert GPIO signal to GPIO pin number */
#define GPIO_TO_PIN(bank, gpio) (32 * (bank) + (gpio))


#define GATERO_UART1_RS485EN GPIO_TO_PIN(0,12)
#define GATERO_UART2_RS485EN GPIO_TO_PIN(0,13)
#define GATERO_UART3_RS485EN GPIO_TO_PIN(1,31)
#define GATERO_UART4_RS485EN GPIO_TO_PIN(1,30)


/*
 * Test program for 485 control
 */
int main(int argc, char* argv[])
{
	struct serial_rs485 rs485conf;
	char buffer[20], buffer2[21],uartname[10];
	int i, rv, opt, uartnr,gpio_txen;
	struct termios my_termios, new_termios;
	if (argc > 1)
	{
		uartnr = atoi(argv[1]);
		sprintf(uartname, "/dev/ttyO%d", uartnr);
		switch(uartnr)
		{
			case 1: gpio_txen = GATERO_UART1_RS485EN; break;
			case 2: gpio_txen = GATERO_UART2_RS485EN; break;
			case 3: gpio_txen = GATERO_UART3_RS485EN; break;
			case 4: gpio_txen = GATERO_UART4_RS485EN; break;
			default: printf("The command had out of range uartNr: Only 1 to 4 available.\n"); exit(1);
		}
    	}
  	else
    	{
      		printf("The command had no other arguments. Usage: %s uartNr\n", argv[0]); exit(1);
    	}

	int fd0 = open(uartname, O_RDWR | O_NDELAY | O_NOCTTY);

	rs485conf.flags = (1<<0); //SER_RS485_ENABLED;
	rs485conf.flags |= SER_RS485_USE_GPIO;
	rs485conf.delay_rts_before_send = 0;
	rs485conf.gpio_pin = gpio_txen;

	rv = ioctl (fd0, TIOCSRS485, &rs485conf);
	if (rv) {
		printf("rv = %d\n", rv);
		perror("unable to set IOCTL:");
	}

	tcgetattr(fd0, &my_termios);
	my_termios.c_iflag &= ~(IGNBRK | BRKINT | ICRNL | INLCR | PARMRK | INPCK | ISTRIP | IXON);
	my_termios.c_oflag &= ~(OCRNL | ONLCR | ONLRET | ONOCR | OFILL | OLCUC | OPOST);
	my_termios.c_lflag &= ~(ECHO | ECHONL | ICANON | IEXTEN | ISIG | ECHOK | ECHOCTL | ECHOPRT);
	my_termios.c_cflag &= ~(CSIZE | PARENB);
	my_termios.c_cflag &= ~CRTSCTS;
	my_termios.c_cflag |= CS8 | CLOCAL;
	my_termios.c_cflag &= ~CBAUD;
	my_termios.c_cflag |= B115200; //B115200; // B19200; // 
	my_termios.c_cc[VMIN] = 1;
	my_termios.c_cc[VTIME] = 0;
	rv = tcsetattr(fd0, TCSANOW, &my_termios);
	tcgetattr(fd0, &new_termios);


	for (i = 0; i < 20; i++) {
		buffer[i] = 'A'+i;
	}

	for (i = 0; i < 1; i++) {
		printf("Writing [%d]\n", i);
		write(fd0, buffer, 15);
		sleep(1);
	}
	close(fd0);
}
